/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PropertySupport {
    private PropertyDefinitions definitions = null;
    private Object[] properties = null;

    public void setProperties(@Nonnull Class<? extends Propertized> ownerClass, @Nullable Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        Preconditions.checkNotNull(definitions);
        if (properties == null && this.definitions != null) {
            this.migrateToNewDefinitions(ownerClass, definitions);
            return;
        }
        this.definitions = definitions;
        this.properties = new Object[definitions.getPropertyDefinitions().size()];
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Preconditions.checkState(ownerClass.equals(definitions.getEffectivity()), "Property definitions of %s cannot be used for %s.", definitions.getEffectivity(), ownerClass);
        for (Map.Entry<PropertyDefinition, String> pv : properties.entrySet()) {
            PropertyDefinition propertyDefinition = pv.getKey();
            Object value = propertyDefinition.getType().toValue(pv.getValue());
            Preconditions.checkArgument(ownerClass.isAssignableFrom(propertyDefinition.getEffectivity()), "Cannot apply property for %s to %s.", propertyDefinition.getEffectivity(), (Object)ownerClass.getName());
            Preconditions.checkArgument(definitions.getEffectivity().isAssignableFrom(propertyDefinition.getEffectivity()), "Cannot apply property for %s to %s.", propertyDefinition.getEffectivity(), (Object)definitions.getEffectivity().getName());
            Integer position = definitions.getPosition(propertyDefinition);
            this.properties[position.intValue()] = value;
        }
    }

    private void migrateToNewDefinitions(@Nonnull Class<? extends Propertized> ownerClass, @Nonnull PropertyDefinitions definitions) {
        if (definitions == this.definitions) {
            return;
        }
        Preconditions.checkState(ownerClass.equals(definitions.getEffectivity()), "Property definitions of %s cannot be used for %s.", definitions.getEffectivity(), ownerClass);
        Object[] newProps = new Object[definitions.getPropertyDefinitions().size()];
        for (PropertyDefinition def : definitions.getPropertyDefinitions()) {
            newProps[definitions.getPosition((PropertyDefinition)def).intValue()] = this.getProperty(def.getName());
        }
        this.properties = newProps;
    }

    public void resetProperties(@Nonnull Class<? extends Propertized> ownerClass, @Nonnull Map<PropertyDefinition, Object> newProperties) {
        Preconditions.checkNotNull(ownerClass);
        Preconditions.checkNotNull(newProperties);
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = null;
        }
        for (Map.Entry<PropertyDefinition, Object> entry : newProperties.entrySet()) {
            PropertyDefinition pd = entry.getKey();
            PropertySupport.checkEffectivity(ownerClass, pd);
            Integer position = this.definitions.getPosition(pd);
            this.properties[position.intValue()] = entry.getValue();
        }
    }

    public void setProperty(@Nonnull Class<? extends Propertized> ownerClass, @Nonnull PropertyDefinition pd, Object value) {
        if (this.definitions == null) {
            throw new UnsupportedOperationException("Setting a property when setProperties() was not yet called is not supported.");
        }
        Preconditions.checkNotNull(pd, "Property definition is null.");
        PropertySupport.checkEffectivity(ownerClass, pd);
        Integer position = this.definitions.getPosition(pd);
        Preconditions.checkNotNull(position, "The property %s for %s has no assigned position.", (Object)pd.getName(), pd.getEffectivity());
        if (value == null) {
            this.properties[position.intValue()] = null;
            return;
        }
        Preconditions.checkArgument(pd.getType().getValueClass().isAssignableFrom(value.getClass()), "Value %s of type %s cannot be assigned to property %s with type %s.", (Object)value.toString(), (Object)value.getClass().getCanonicalName(), (Object)pd.getName(), (Object)pd.getType().getValueClass().getCanonicalName());
        this.properties[position.intValue()] = value;
    }

    public Object getProperty(@Nonnull String name) {
        if (this.definitions == null) {
            throw new UnsupportedOperationException("Getting a property value when setProperties() was not yet called is not supported now.");
        }
        Preconditions.checkNotNull(name, "property name cannot be null");
        Integer position = this.definitions.getPosition(name);
        return position == null ? null : this.properties[position];
    }

    public Object getProperty(@Nonnull Class<? extends Propertized> ownerClass, @Nonnull PropertyDefinition def) {
        if (this.definitions == null) {
            throw new UnsupportedOperationException("Getting a property value when setProperties() was not yet called is not supported now.");
        }
        PropertySupport.checkEffectivity(ownerClass, def);
        Integer position = this.definitions.getPosition(def);
        return position == null ? null : this.properties[position];
    }

    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        if (this.definitions == null) {
            throw new UnsupportedOperationException("Getting a property value when setProperties() was not yet called is not supported now.");
        }
        HashMap<PropertyDefinition, Object> props = Maps.newHashMap();
        for (PropertyDefinition pd : this.definitions.getPropertyDefinitions()) {
            Object value = this.properties[this.definitions.getPosition(pd)];
            if (value == null) continue;
            props.put(pd, value);
        }
        return props;
    }

    private static void checkEffectivity(@Nonnull Class<? extends Propertized> ownerClass, @Nonnull PropertyDefinition pd) {
        Preconditions.checkArgument(ownerClass.isAssignableFrom(pd.getEffectivity()), "Cannot use property definition %s with effectivity %s on %s", (Object)pd.getName(), (Object)pd.getEffectivity().getSimpleName(), (Object)ownerClass.getSimpleName());
    }
}

